/*
 * Decompiled with CFR 0.152.
 */
package net.coobird.thumbnailator;

import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;
import net.coobird.thumbnailator.filters.ImageFilter;
import net.coobird.thumbnailator.geometry.Region;
import net.coobird.thumbnailator.resizers.FixedResizerFactory;
import net.coobird.thumbnailator.resizers.Resizer;
import net.coobird.thumbnailator.resizers.ResizerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThumbnailParameter {
    public static final String ORIGINAL_FORMAT = null;
    public static final String DETERMINE_FORMAT = "\u0000";
    public static final String DEFAULT_FORMAT_TYPE = null;
    public static final float DEFAULT_QUALITY = Float.NaN;
    public static final int ORIGINAL_IMAGE_TYPE = -1;
    public static final int DEFAULT_IMAGE_TYPE = 2;
    private final Dimension thumbnailSize;
    private final double widthScalingFactor;
    private final double heightScalingFactor;
    private final boolean keepAspectRatio;
    private final String outputFormat;
    private final String outputFormatType;
    private final float outputQuality;
    private final int imageType;
    private final List<ImageFilter> filters;
    private final ResizerFactory resizerFactory;
    private final Region sourceRegion;
    private final boolean fitWithinDimensions;
    private final boolean useExifOrientation;

    private ThumbnailParameter(Dimension dimension, double d, double d2, Region region, boolean bl, String string2, String string3, float f2, int n, List<ImageFilter> list2, ResizerFactory resizerFactory, boolean bl2, boolean bl3) {
        this.thumbnailSize = dimension;
        this.widthScalingFactor = d;
        this.heightScalingFactor = d2;
        this.keepAspectRatio = bl;
        this.sourceRegion = region;
        this.outputFormat = string2;
        this.outputFormatType = string3;
        if ((f2 < 0.0f || f2 > 1.0f) && !Float.isNaN(f2)) {
            throw new IllegalArgumentException("The output quality must be between 0.0f and 1.0f, or Float.NaN to use the default compression quality of codec being used.");
        }
        this.outputQuality = f2;
        this.imageType = n;
        this.filters = list2 == null ? new ArrayList<ImageFilter>() : new ArrayList<ImageFilter>(list2);
        if (resizerFactory == null) {
            throw new IllegalArgumentException("Resizer cannot be null");
        }
        this.resizerFactory = resizerFactory;
        this.fitWithinDimensions = bl2;
        this.useExifOrientation = bl3;
    }

    private void validateThumbnailSize() {
        if (this.thumbnailSize == null) {
            throw new IllegalArgumentException("Thumbnail size cannot be null.");
        }
        if (this.thumbnailSize.width < 0 || this.thumbnailSize.height < 0) {
            throw new IllegalArgumentException("Thumbnail dimensions must be greater than 0.");
        }
    }

    private void validateScalingFactor() {
        if (this.widthScalingFactor <= 0.0 || this.heightScalingFactor <= 0.0) {
            throw new IllegalArgumentException("Scaling factor is less than or equal to 0.");
        }
        if (Double.isNaN(this.widthScalingFactor) || Double.isInfinite(this.widthScalingFactor)) {
            throw new IllegalArgumentException("Scaling factor must be a rational number.");
        }
        if (Double.isNaN(this.heightScalingFactor) || Double.isInfinite(this.heightScalingFactor)) {
            throw new IllegalArgumentException("Scaling factor must be a rational number.");
        }
    }

    public ThumbnailParameter(Dimension dimension, Region region, boolean bl, String string2, String string3, float f2, int n, List<ImageFilter> list2, Resizer resizer, boolean bl2, boolean bl3) {
        this(dimension, Double.NaN, Double.NaN, region, bl, string2, string3, f2, n, list2, new FixedResizerFactory(resizer), bl2, bl3);
        this.validateThumbnailSize();
    }

    public ThumbnailParameter(double d, double d2, Region region, boolean bl, String string2, String string3, float f2, int n, List<ImageFilter> list2, Resizer resizer, boolean bl2, boolean bl3) {
        this(null, d, d2, region, bl, string2, string3, f2, n, list2, new FixedResizerFactory(resizer), bl2, bl3);
        this.validateScalingFactor();
    }

    public ThumbnailParameter(Dimension dimension, Region region, boolean bl, String string2, String string3, float f2, int n, List<ImageFilter> list2, ResizerFactory resizerFactory, boolean bl2, boolean bl3) {
        this(dimension, Double.NaN, Double.NaN, region, bl, string2, string3, f2, n, list2, resizerFactory, bl2, bl3);
        this.validateThumbnailSize();
    }

    public ThumbnailParameter(double d, double d2, Region region, boolean bl, String string2, String string3, float f2, int n, List<ImageFilter> list2, ResizerFactory resizerFactory, boolean bl2, boolean bl3) {
        this(null, d, d2, region, bl, string2, string3, f2, n, list2, resizerFactory, bl2, bl3);
        this.validateScalingFactor();
    }

    public Dimension getSize() {
        if (this.thumbnailSize != null) {
            return (Dimension)this.thumbnailSize.clone();
        }
        return null;
    }

    public double getWidthScalingFactor() {
        return this.widthScalingFactor;
    }

    public double getHeightScalingFactor() {
        return this.heightScalingFactor;
    }

    public int getType() {
        return this.imageType;
    }

    public boolean isKeepAspectRatio() {
        return this.keepAspectRatio;
    }

    public String getOutputFormat() {
        return this.outputFormat;
    }

    public String getOutputFormatType() {
        return this.outputFormatType;
    }

    public float getOutputQuality() {
        return this.outputQuality;
    }

    public List<ImageFilter> getImageFilters() {
        return this.filters;
    }

    public Resizer getResizer() {
        return this.resizerFactory.getResizer();
    }

    public ResizerFactory getResizerFactory() {
        return this.resizerFactory;
    }

    public boolean useOriginalImageType() {
        return this.imageType == -1;
    }

    public Region getSourceRegion() {
        return this.sourceRegion;
    }

    public boolean fitWithinDimenions() {
        return this.fitWithinDimensions;
    }

    public boolean useExifOrientation() {
        return this.useExifOrientation;
    }
}

